<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>SG60 Homecoming Concert</title>
  <script src="https://cdn.tailwindcss.com"></script>

  <!-- Load LEMONMILK Font -->
  <style>
    @font-face {
      font-family: 'LemonMilk';
      src: url('https://singevent.com/e/SG60HomecomingConcert/fonts/VAGRounded-Lt-Regular.ttf') format('opentype');
      font-weight: normal;
      font-style: normal;
    }
    
    
    .lemonmilk {
      font-family: 'LemonMilk', sans-serif;
    }
  </style>
</head>
<body class="lemonmilk min-h-screen flex flex-col bg-cover bg-center text-white" style="background-image: url('https://singevent.com/e/SG60HomecomingConcert/background.png')">

  <!-- Content Wrapper -->
  <div class="flex-grow flex flex-col items-center px-4 text-center">

    <!-- Top Logos -->
    <div class="flex flex-row justify-center items-center gap-12 pt-6">
      <img src="CAG_logo_2.png" alt="Changi Logo" class="h-14">
      <img src="SG60.png" alt="SG60 Logo" class="h-14">
      <img src="Jewel_logo2.png" alt="Jewel Logo" class="h-14">
    </div>

    <!-- Event Details Row -->
    <p class="mt-6 text-sm sm:text-base font-medium">
      1 Aug 2025 &nbsp; | &nbsp; Level 1 Forest Valley &nbsp; | &nbsp; 7:00pm
    </p>

    <!-- Main Title -->
    <h1 class="text-3xl sm:text-5xl font-bold mt-4">SG60 Homecoming Concert</h1>

    <!-- Subtitle -->
    <p class="text-sm sm:text-lg mt-4 max-w-xl">
     Celebrate Singapore's birthday at Changi's SG60 sing-along concert, with our homegrown music heroes: 
    </p>

    <!-- Artist List -->
    <div class="mt-4 text-base sm:text-lg font-medium leading-relaxed">
      <p>Stefanie Sun</p>
      <p>Kit Chan</p>
      <p>Sezairi</p>
      <p>Regina Song</p>
      <p>The Freshman</p>
      <p>SuperSonic</p>
    </div>

    <!-- Register Button -->
    <div class="mt-6">
      <a href="https://singevent.com/e/SG60HomecomingConcert/public"
         class="inline-block px-8 py-3 text-white text-lg font-semibold rounded-full bg-gradient-to-r from-purple-500 via-pink-500 to-blue-500 shadow-md border border-white/30 backdrop-blur-sm hover:scale-105 transition-transform duration-300">
         Register to Ballot for<br>a pair of tickets
      </a>
    </div>

  </div>

  <!-- Footer -->
  <footer class="w-full px-4 py-4 text-xs text-center text-black bg-white">
    Terms & Conditions apply.<br>For more information, visit 
    <a href="https://www.changiairport.com/sg60concert" class="underline">www.changiairport.com/sg60concert</a>
  </footer>

</body>
</html>
