<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>HSBC D&D 2025  Registration</title>
  <link href="https://cdnjs.cloudflare.com/ajax/libs/normalize/8.0.1/normalize.min.css" rel="stylesheet">

  <style>
    /* Load custom font */
    @font-face {
      font-family: 'BebasKai';
      src: url('fonts/BebasKai.ttf') format('truetype');
      font-weight: normal;
      font-style: normal;
    }

    :root {
      --cream: rgba(255,255,255,0.86);
      --stroke: rgba(0,0,0,0.28);
      --btn: #99191a;
      --btn-dark: #6e1213;
      --label: #99191a;
      --text: #1c1c1c;
    }

    html, body { height: 100%; }

    body {
      margin: 0;
      font-family: 'BebasKai', sans-serif; /* apply everywhere */
      background: #000 url("images/Registration-BGG.jpg") center/cover fixed no-repeat;
      overflow-x: hidden;
    }

    /* Layout */
    .shell {
      min-height: 100dvh;
      display: grid;
      place-items: center;
      padding: clamp(12px, 3vw, 28px);
    }

    .grid {
      width: min(1280px, 96vw);
      display: grid;
      grid-template-columns: 1fr;
      gap: 24px;
    }

    /* Desktop: shift the entire card (logo + form + ticket note) further right */
    @media (min-width: 1024px) {
      .grid {
        grid-template-columns: 580px 1fr; /* form column on the left */
      }
      .grid > .card {
        grid-column: 1;
        justify-self: start;
        margin-left: clamp(140px, 14vw, 280px); /* increase to push more right */
      }
      .grid > div:first-child {
        grid-column: 2; /* artwork spacer stays on the right */
      }
    }

    /* Card & form */
    .card {
      background: rgba(0,0,0,0.0);
      padding: 8px;
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    .form {
      display: grid;
      gap: 14px;
      width: 100%;
      max-width: 520px; /* lock consistent width for all fields */
    }

    .label {
      font-weight: 700;
      letter-spacing: 0.16em;
      color: var(--label);
      text-transform: uppercase;
      font-size: .92rem;
      margin-bottom: 6px;
    }

    .field, .select {
      display: block;
      width: 100% !important;
      box-sizing: border-box;
      background: var(--cream);
      border: 1px solid var(--stroke);
      border-radius: 8px;
      padding: 12px 14px;
      font-size: 1rem;
      color: var(--text);
      outline: none;
      transition: box-shadow .15s ease, transform .15s ease;
      font-family: 'BebasKai', sans-serif; /* force on form fields */
    }

    .field::placeholder {
      color: #6b6b6b;
      font-family: 'BebasKai', sans-serif;
    }

    .field:focus, .select:focus {
      box-shadow: 0 0 0 3px rgba(153,25,26,.35); /* theme red glow */
    }

    /* Ensure spacing for "Other department" */
    #department_other {
      margin-top: 10px;
    }

    /* Button */
    .btn {
      display: inline-block;
      border: 0;
      cursor: pointer;
      padding: 12px 20px;
      border-radius: 10px;
      background: linear-gradient(180deg, var(--btn), var(--btn-dark));
      color: #fff;
      font-weight: 700;
      letter-spacing: .06em;
      box-shadow: 0 10px 24px rgba(0,0,0,.35);
      transition: transform .15s ease, box-shadow .15s ease, filter .15s ease;
      text-transform: uppercase;
      font-family: 'BebasKai', sans-serif;
    }

    .btn:hover { transform: translateY(-2px); filter: brightness(1.05); }
    .btn:active { transform: translateY(0); }

    /* Logo */
    .form-logo {
      height: clamp(70px, 10vw, 120px); /* smaller */
      margin-bottom: 16px;
      filter: drop-shadow(0 4px 12px rgba(0,0,0,.45));
    }

    /* Ticket text */
    .ticket-note {
      margin-top: 14px;
      font-size: .95rem;
      font-weight: 600;
      color: #99191a;
      text-transform: uppercase;
      letter-spacing: .12em;
      text-align: center;
      background: rgba(255,255,255,0.6);
      padding: 4px 10px;
      border-radius: 6px;
      font-family: 'BebasKai', sans-serif;
    }

    .hidden { display: none; }
  </style>
</head>
<body>
  <main class="shell">
    <div class="grid">
      <div></div> <!-- empty column for artwork -->

      <!-- Left column on desktop: logo + form + ticket note -->
      <section class="card" aria-label="Registration">
        <!-- Logo above form -->
        <img class="form-logo" src="images/bk-event_logo.png" alt="Event Logo">

        <form class="form" action="register_response.php" method="POST" autocomplete="on" novalidate>
          <div>
            <div class="label">Name</div>
            <input class="field" type="text" name="fullname" placeholder="Your full name" required>
          </div>

          <div>
            <div class="label">Staff ID</div>
            <input class="field" type="text" name="staff_id" placeholder="e.g., 123456" required>
          </div>

          <div>
            <div class="label">Department</div>
            <select class="select" name="department" id="department" required>
              <option value="" selected disabled>Select department</option>
              <option>Central Management Services & Office</option>
              <option>CIB - Banking</option>
              <option>CIB - Capital Markets and Advisory</option>
              <option>CIB - Chief Commercial Office</option>
              <option>CIB - Chief Operating Office</option>
              <option>CIB - Global Payments Solutions</option>
              <option>CIB - Global Research</option>
              <option>CIB - Global Trade Solutions</option>
              <option>CIB - HSBC Infrastructure and Sustainability</option>
              <option>CIB - Markets and Securities Services</option>
              <option>Communications</option>
              <option>Finance</option>
              <option>Governance</option>
              <option>Group Chief Information Office</option>
              <option>Group Chief Operating Office</option>
              <option>Internal Audit</option>
              <option>IWPB - Asset Management</option>
              <option>IWPB - Chief Commercial Office</option>
              <option>IWPB - Chief Operating Office</option>
              <option>IWPB - Private Bank</option>
              <option>IWPB - HSBC Life</option>
              <option>IWPB - International Wealth & Premier Banking</option>
              <option>IWPB - Wealth and Premier Solutions</option>
              <option>Legal</option>
              <option>People</option>
              <option>Risk & Compliance</option>
              <option>Sustainability</option>
              <option value="Other">Others (please specify)</option>
            </select>
            <input class="field hidden" type="text" id="department_other" name="department_other" placeholder="Enter department name">
          </div>

          <div>
            <div class="label">Email ID</div>
            <input class="field" type="email" name="email" placeholder="you@company.com" required>
          </div>

          <div>
            <div class="label">Dietary Restriction (Halal Certified)</div>
            <select class="select" name="dietary" required>
              <option value="" selected disabled>Select an option</option>
              <option>Non-Alcohol</option>
              <option>With Alcohol</option>
              <option>Vegetarian</option>
            </select>
          </div>

          <div>
            <div class="label">Do you need transportation?</div>
            <select class="select" name="transport" required>
              <option value="" selected disabled>Select a pickup</option>
              <option>No</option>
              <option>MBC</option>
              <option>Raffles</option>
              <option>Claymore</option>
            </select>
          </div>

          <div style="margin-top:10px;">
            <button class="btn" type="submit">Done</button>
          </div>
        </form>

        <!-- Ticket note below form -->
        <div class="ticket-note">Ticket Valid for 1 Person</div>
      </section>
    </div>
  </main>

  <script>
    // Department "Others" reveal
    const dept = document.getElementById('department');
    const deptOther = document.getElementById('department_other');
    dept.addEventListener('change', () => {
      if (dept.value === 'Other') {
        deptOther.classList.remove('hidden');
        deptOther.required = true;
        deptOther.focus();
      } else {
        deptOther.classList.add('hidden');
        deptOther.required = false;
        deptOther.value = '';
      }
    });
  </script>
</body>
</html>
