<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>HSBC DND 2025</title>
  <link rel="preload" as="video" href="option1.mp4" type="video/mp4">
  <link rel="preload" as="image" href="poster.jpg">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/normalize/8.0.1/normalize.min.css" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
  <style>
    html, body { height: 100%; margin: 0; }
    body {
      font-family: 'Inter', system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif;
      color: #fff; background: #000; overflow-x: hidden;
    }
    /* Fullscreen background video */
    #bg-video { position: fixed; inset: 0; width: 100%; height: 100%; object-fit: cover; z-index: -2; }

    /* Header */
    .header { position: fixed; top: 0; left: 0; right: 0; display: flex; justify-content: center; padding: clamp(10px, 2.5vw, 24px); }
    .logo { height: clamp(36px, 6vw, 80px); width: auto; filter: drop-shadow(0 4px 12px rgba(0,0,0,0.4)); }

    /* Center content */
    .center { min-height: 100dvh; display: grid; place-items: center; padding: 16px; }
    .stack { width: min(1100px, 92vw); display: grid; gap: clamp(16px, 3vw, 28px); justify-items: center; text-align: center; }

    .title { display: none; }

    /* Image-based arrow menu */
    .menu-arrows {
      position: relative;
      display: flex;
      flex-direction: column;
      align-items: flex-start;
      gap: 10px;
      margin-left: clamp(8px, 3vw, 24px);
    }
    .menu-arrows a {
      display: inline-block;
      line-height: 0;
      transform-origin: left center;
      transition: transform .18s ease, filter .18s ease;
    }
    .menu-arrows img {
      width: clamp(220px, 24vw, 360px);
      height: auto;
      display: block;
      filter: drop-shadow(0 6px 12px rgba(0,0,0,.35));
    }
    .menu-arrows a:hover { transform: translateX(4px) scale(1.02); }
    .menu-arrows a:active { transform: translateX(2px) scale(0.99); }

    /* Footer */
    .footer { position: fixed; left: 0; right: 0; bottom: 0; display: flex; justify-content: center; padding: 10px 14px; font-size: 12px; color: rgba(255,255,255,0.7); }

    /* Audio toggle */
    .audio-toggle { position: fixed; right: 16px; bottom: 70px; z-index: 10; border: 1px solid rgba(255,255,255,0.25); background: rgba(0,0,0,0.45); color: #fff; backdrop-filter: blur(6px); height: 48px; min-width: 48px; padding: 0 14px; border-radius: 999px; font-weight: 600; cursor: pointer; box-shadow: 0 8px 24px rgba(0,0,0,0.35); display: inline-flex; align-items: center; gap: 8px; }
    .audio-toggle[hidden] { display: none; }
    
    /* Default (mobile/tablet): centered — already your current behavior */
.header { justify-content: center; }
.stack { justify-items: center; }
.menu-arrows { align-items: center; margin-left: 0; margin-right: 0; }
.menu-arrows a { transform-origin: center; }
.menu-arrows a:hover { transform: translateX(4px) scale(1.02); } /* slight nudge right */

/* Desktop: move logo + menu to the right side */
@media (min-width: 1024px) {
  .header {
    justify-content: flex-end;       /* logo to the right */
    padding-right: clamp(12px, 3vw, 40px);
  }

  .stack {
    justify-items: end;              /* content aligns right */
  }

  .menu-arrows {
    align-items: flex-end;           /* stack items to the right */
    margin-right: clamp(12px, 3vw, 40px);
    margin-left: 0;
  }

  .menu-arrows a {
    transform-origin: right center;  /* animations originate from the right */
  }

  .menu-arrows a:hover {
    transform: translateX(-4px) scale(1.02); /* nudge left on hover (toward center) */
  }
}
/* Default (mobile/tablet): centered — already your current behavior */
.header { justify-content: center; }
.stack { justify-items: center; }
.menu-arrows { align-items: center; margin-left: 0; margin-right: 0; }
.menu-arrows a { transform-origin: center; }
.menu-arrows a:hover { transform: translateX(4px) scale(1.02); }



/* Desktop: menu fixed to the very left edge */
@media (min-width: 1024px) {
  .menu-arrows {
    position: fixed;
    top: 25vh;                 /* vertical position, adjust as needed */
    left: 16px;                /* distance from the left edge */
    margin: 0;                 /* reset margins */
    align-items: flex-start;
  }

  .stack {
    justify-items: start;      /* keeps any other content aligned left */
  }

  .header {
    justify-content: flex-start;
    padding-left: 16px;
  }
  
   .logo {
    height: clamp(80px, 10vw, 140px);  /* bigger logo size */
    margin-left: 200px;                 /* push a bit to the right */
  }
}


/* Mobile/tablet: make logo larger */
@media (max-width: 1023px) {
  .logo {
    height: clamp(60px, 20vw, 100px);  /* min 60px, max 100px */
  }
}

  </style>
</head>
<body>
  <!-- Background Video -->
  <video id="bg-video" autoplay muted playsinline webkit-playsinline loop preload="auto" poster="poster.jpg" crossorigin="anonymous">
    <source src="videos/confirmed_BG.mp4" type="video/mp4" />
    Your browser does not support the video tag.
  </video>

  <!-- Header: Logo centered at the top -->
  <header class="header" role="banner">
    <a href="#home" aria-label="Home">
      <img src="images/event_logo.png" class="logo" alt="Event Logo" />
    </a>
  </header>

  <!-- Main content: Menu -->
  <main class="center" role="main">
    <div class="stack">
      <h1 class="title">HSBC DND 2025</h1>

      <nav class="menu-arrows" aria-label="Primary">
        <a href="register.php" aria-label="Register"><img src="images/register.png" alt="Register"></a>
        <a href="#performances" aria-label="Performances"><img src="images/performances.png" alt="Performances"></a>
        <a href="#story" aria-label="The Story"><img src="images/story.png" alt="The Story"></a>
        <a href="#dresscode" aria-label="Dress Code"><img src="images/dresscode.png" alt="Dress Code"></a>
        <a href="#directions" aria-label="Directions"><img src="images/directions.png" alt="Directions"></a>
        <a href="#contact" aria-label="Contact Us"><img src="images/contact.png" alt="Contact Us"></a>
      </nav>
    </div>

    <!-- Audio toggle -->
    <button id="audioToggle" class="audio-toggle" type="button">
      <span aria-hidden="true">🔈</span>
      <span>Enable Sound</span>
    </button>
  </main>

  <!-- Footer -->
  <footer class="footer">
    <span>© <span id="year"></span> HSBC DND • All rights reserved</span>
  </footer>

  <script>
    const v = document.getElementById('bg-video');
    const audioBtn = document.getElementById('audioToggle');

    if (v) {
      v.muted = true;
      const tryPlay = () => v.play().catch(() => {});
      document.addEventListener('visibilitychange', tryPlay, { passive: true });
      window.addEventListener('load', tryPlay, { once: true, passive: true });

      async function enableSound() {
        try {
          const AC = window.AudioContext || window.webkitAudioContext;
          if (AC) {
            const ctx = new AC();
            if (ctx.state === 'suspended') await ctx.resume();
          }
          v.pause();
          v.removeAttribute('muted');
          v.muted = false;
          v.volume = 1.0;
          try { v.currentTime = Math.max(0.001, v.currentTime || 0.001); } catch(e) {}
          await v.play();
          audioBtn && (audioBtn.hidden = true);
        } catch (e) {
          console.warn('Unmute failed:', e?.message || e);
          if (audioBtn) {
            audioBtn.querySelector('span[aria-hidden="true"]').textContent = '🔇';
            audioBtn.querySelector('span:last-child').textContent = 'Tap again to enable sound';
          }
        }
      }

      if (audioBtn) {
        audioBtn.hidden = false;
        audioBtn.addEventListener('click', enableSound, { passive: true });
      }
      const oneTime = () => { enableSound(); document.removeEventListener('click', oneTime); };
      document.addEventListener('click', oneTime, { once: true });
    }

    document.getElementById('year').textContent = new Date().getFullYear();
  </script>
</body>
</html>
